local assets=
{
    Asset("ANIM", "anim/kurumi_gun.zip"),
    Asset("ANIM", "anim/kurumi_gun_swap.zip"),
 
    Asset("ATLAS", "images/kurumi_gun.xml"),
  
}

local beidong = 
{
	[1] = function(inst, attacker, target)
		target:DoTaskInTime(1, function() target.components.health:DoDelta(-33) end)
		attacker.components.locomotor:SetExternalSpeedMultiplier(inst, "kurumi_gun", 2)
		attacker:DoTaskInTime(20, function() attacker.components.locomotor:SetExternalSpeedMultiplier(inst, "kurumi_gun", 1) end)
	end,
	
	[2] = function(inst, attacker, target)
		attacker.components.combat.damagemultiplier = 2
		attacker:DoTaskInTime(20, function() 
			attacker.components.combat.damagemultiplier = 1
		end)
		if target.components.locomotor then
			target.components.locomotor:SetExternalSpeedMultiplier(inst, "kurumi_gun_2", .75)
		end
		target.old_min_attack_period = target.components.combat.min_attack_period 
		target.components.combat.min_attack_period = target.old_min_attack_period * 1.5
		target:DoTaskInTime(20, function() 
			if target.components.locomotor then
				target.components.locomotor:SetExternalSpeedMultiplier(inst, "kurumi_gun_2", 1)
			end
			target.components.combat.min_attack_period = target.old_min_attack_period
		end)
	end,
	
	[3] = function(inst, attacker, target)
		if math.random() < .03 then
			local fenshen = SpawnPrefab("kurumi_self")
			fenshen.Transform:SetPosition( target.Transform:GetWorldPosition() )
			fenshen.components.follower:SetLeader(attacker)
			fenshen.master = attacker
		end
		target:ListenForEvent("death", function(target, data)
			if math.random() < .1 then
				local fenshen = SpawnPrefab("kurumi_self")
				fenshen.Transform:SetPosition( target.Transform:GetWorldPosition() )
				fenshen.components.follower:SetLeader(attacker)
			end
		end)
	end,
	
	[4] = function(inst, attacker, target)
		attacker.components.health:DoDelta(33)
		attacker.components.sanity:DoDelta(33)
	end,
	
	[5] = function(inst, attacker, target)
		local fx = SpawnPrefab("lightning")
		fx.Transform:SetPosition( target.Transform:GetWorldPosition() )
		target.components.health:DoDelta(-5)
		target:ListenForEvent("death", function(target, data)
			if attacker.components.kurumi_timepiont then
				attacker.components.kurumi_timepiont:DoDelta(33)
			end
		end)
	end,
	
	[6] = function(inst, attacker, target)
		local pos1 = attacker:GetPosition()
		local pos2 = target:GetPosition()
		local dist = pos1:Dist(pos2) + 2
		local angle = attacker:GetAngleToPoint(pos2)
		local x,y,z = pos1:Get()
		local x2,y2,z2 = x+math.cos(angle)*dist, 0, z-math.sin(angle)*dist
		attacker.Transform:SetPosition(x2,y2,z2)
		if not attacker:IsOnValidGround() then
			attacker:DoTaskInTime(0, function() attacker.Transform:SetPosition(x,y,z) end)
		end
	end,
	
	[7] = function(inst, attacker, target)
		if target.components.freezable then
			target.components.freezable:AddColdness(10, 3)
			target.components.health:DoDelta(-33)
		end
	end,
	
	[8] = function(inst, attacker, target)
		local fenshen = SpawnPrefab("kurumi_self")
		fenshen.Transform:SetPosition( target.Transform:GetWorldPosition() )
		fenshen.components.follower:SetLeader(attacker)
		fenshen.master = attacker
		fenshen.alive_time = 200
	end,
	
	[9] = function(inst, attacker, target)
		if math.random() < .1 then
			local v = target
			if v.components.health and not v.components.health:IsDead() and v.components.combat then
				--静止
				if v.brain then
					v.brain:Stop()
				end
				if v.components.combat then
					v.components.combat:SetTarget(nil)
				end
				if v.components.locomotor then
					v.components.locomotor:Stop()
				end
				
				--强制idle
				if v.sg and v.sg.sg and v.sg.sg.states and v.sg.sg.states["idle"] then
					v.sg:GoToState("idle")
				end
				
				v:DoTaskInTime(2, function()
					if v and v.brain then
						v.brain:Start()
					end
				end)
				
			end
			
			if attacker.components.kurumi_timepiont then
				attacker.components.kurumi_timepiont:DoDelta(33)
			end
		end
	end,
	
	[10] = function(inst, attacker, target)
		target.components.health:DoDelta(-33 * .2)
	end,
	
	[11] = function(inst, attacker, target)
		local x,y,z = attacker.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x,y,z,10,{"player"}, {"playerghost"})
		for k,v in pairs(ents) do
			if v and v.components.health and not v.components.health:IsDead() then
				v.components.health:DoDelta(10)
			end
		end
		if target.components.burnable then
			if target.xiana_task == nil then
				target.components.burnable:SpawnFX()
				target.xiana_task = target:DoPeriodicTask(1, function()
					target.components.health:DoDelta(-10 * target.components.health.fire_damage_scale)
				end)
				target:DoTaskInTime(5, function()
					if target.xiana_task ~= nil then
						target.xiana_task:Cancel()
						target.xiana_task = nil
						target.components.burnable:KillFX()
					end
				end)
			end
		end
	end,
	
	[12] = function(inst, attacker, target)
		local fenshen = SpawnPrefab("kurumi_self")
		fenshen.Transform:SetPosition( target.Transform:GetWorldPosition() )
		fenshen.components.follower:SetLeader(attacker)
		fenshen.mode = 1
	end,
	
}

local function onattack(inst, attacker, target)

	--水的效果
	local water = SpawnPrefab("waterballoon")
	water.Transform:SetPosition( target.Transform:GetWorldPosition() )
	water.components.complexprojectile:Hit(target)

	if math.random() < .12 then
		beidong[math.random(#beidong)](inst, attacker, target)
		--beidong[1](inst, attacker, target)
		
		--召唤刻刻帝
		local kekedi = SpawnPrefab("kurumi_kekedi")
		kekedi.entity:SetParent(attacker.entity)
		
		local down = TheCamera:GetDownVec()
        local angle = math.atan2(down.z, down.x) + PI
        kekedi.Transform:SetPosition( math.cos(angle), 0, -math.sin(angle))
		
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("kurumi_gun")
    inst.AnimState:SetBuild("kurumi_gun")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("extinguisher")
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	local function healowner(inst, owner)
		if owner.components.kurumi_timepiont then
			owner.components.kurumi_timepiont:DoDelta( .05 * owner.components.kurumi_timepiont.maxtimepiont )
		end
	end
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "kurumi_gun_swap", "kurumi_gun_swap")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
		inst.task = inst:DoPeriodicTask(5, healowner, nil, owner)
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
		if inst.task ~= nil then
			inst.task:Cancel()
			inst.task = nil
		end
    end
 
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "kurumi_gun"
    inst.components.inventoryitem.atlasname = "images/kurumi_gun.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("inspectable")
		
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetDamage(33)
    inst.components.weapon:SetRange(8, 10)
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

    return inst
	
end
	
return  Prefab("kurumi_gun", fn, assets)